global script_node

local controls = FindNodeByName("AllControlsScript")
local prop = FindNodeByName("Ob2_3Prop")
local handlestate

handlestate = 0

-- space/time throttle

global function AnimDone()
	local anim 
	local ce4 = FindNodeByName("ce4")
	
	ce4:Trigger()
		
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_directional_Anim_Directional_Pointer_right_idle")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_directional_Anim_Directional_Pointer_left_idle")
	end

	prop:PlayAnim(anim, 1, 0)
	controls.script.TurnOnInterface()	
	--Locking down mech
	controls.script.InteractDone()
end

global function PlayUp()
	local anim = FindNodeByShortName("EM_ANIMATOR_directional_Anim_Directional_Pointer_left_rotate")

	handlestate = 1

	FindNodeByName("ob_2_3_direction_left"):Trigger()

	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function PlayDown()
	local anim = FindNodeByShortName("EM_ANIMATOR_directional_Anim_Directional_Pointer_right_rotate")

	handlestate = 0

	FindNodeByName("ob_2_3_direction_right"):Trigger()
	
	prop:PlayAnim(anim, 1, 0)
	prop:SetCallback(script_node, "AnimDone")
end

global function Interact()
	local doctor = GetActor("doctor")
	local amy = GetActor("amy")

	controls.script.TurnOffInterface()
	
	if (handlestate == 0) then
		PlayUp()
	else
		PlayDown()
	end
	
	FindNodeByName("Console2InteractableScript").script.Object3State = handlestate
	
	-- ConsoleDV == 0 is for when exploring tardis
	if controls.script.ConsoleDV == 0 then
		SayPrep("skip","async")

		if(FindNodeByName("CommonScripts").script.DoctorIsPlayer()) then
			--VO 
			--Console Control Text
				doctor::SID_2253:Directional Pointer: Orients the TARDIS in space, letting you turn in any direction. Yeah, when it's working, of course.
		else
			--VO 
			--Console Control Text
				amy::SID_2254:This spins the TARDIS around, great - like it doesn't do enough of that! How do I know which way is up?
		end
	end
end

global function DummyCallback()
end

global function ResetControl()
	local anim
	
	if (handlestate == 0) then
		anim = FindNodeByShortName("EM_ANIMATOR_directional_Anim_Directional_Pointer_right_idle")	
	else
		anim = FindNodeByShortName("EM_ANIMATOR_directional_Anim_Directional_Pointer_left_idle")
	end

	prop:SetCallback(script_node, "DummyCallback")	-- overrides the current callback so nothing happens
	prop:PlayAnim(anim, 1, 0)
	handlestate = 0
end

